
library(data.table)
library(ggplot2)
library(metR)
library(viridis)
library(patchwork)

rm(list=ls())
setwd("C:/Users/Nicky/Dropbox/R Analysis Ventilation")

# #### Create final file - building #####
# 
# Other_pop <- read.csv ("./BuildingsAnalysis/Average count/Average_otherpop_by building.csv")
# Rebreathed_prop <- read.csv ("./BuildingsAnalysis/Rebreathed air/Rebreathed proportion_by building.csv")
# Results_Q <- read.csv("./BuildingsAnalysis/Q results/Results_Q.csv")
# 
# Merged <- cbind(Other_pop, Rebreathed_prop)
# Data.frame <- cbind(Merged, Results_Q)
# Data <- Data.frame[-c(1,2,4,5,8,9,10,11,12)]
# Data <- Data[c(2,7,1,3,4,5,6)]
# 
# write.csv(Data, "./BuildingsAnalysis/Final Results/Final results_building.csv")
# #####

xya.func <- function(q,p) {p/q}

#### Method for manual contour plot - building ####
Results <- read.csv("./BuildingsAnalysis/Final Results/Final results_building.csv")
Results<-Results[!(Results$Other_pop==0),]
Results$risk<-xya.func(Results$Q,Results$Other_pop)
Results$risk_low<-xya.func(Results$CI2,Results$Other_pop)
Results$risk_high<-xya.func(Results$CI1,Results$Other_pop)

Church <- Results[which(Results$Type=="Church"),]
Salon <- Results[which(Results$Type=="Salon"),]
Shebeen <- Results[which(Results$Type=="Shebeen"),]
Shop <- Results[which(Results$Type=="Shop"),]
Clinic <- Results[which(Results$Type=="Clinic"),]

Results_transport <- read.csv("./TransportAnalysis/Final Results/Final results_vehicle.csv")
Results_transport$risk<-xya.func(Results_transport$Q,Results_transport$Other_pop)
Results_transport$risk_low<-xya.func(Results_transport$CI2,Results_transport$Other_pop)
Results_transport$risk_high<-xya.func(Results_transport$CI1,Results_transport$Other_pop)
Results_transport$Peak <- factor(Results_transport$Peak, levels = c("Peak", "Off-peak"))

Bus <- Results_transport[which(Results_transport$Type=="Bus"),]
Bus <- Bus[-c(6,11)]

Train <- Results_transport[which(Results_transport$Type=="Train"),]
Train <- Train[-c(6,11)]

Minibus_Taxi <- Results_transport[which(Results_transport$Type=="Taxi"),]
Minibus_Taxi_Peak <- Minibus_Taxi[which(Minibus_Taxi$Peak=="Peak"),]
Minibus_Taxi_Peak <- Minibus_Taxi_Peak[-c(11)]
Minibus_Taxi_Peak <- Minibus_Taxi_Peak[-c(10),]

Minibus_Taxi_Offpeak <- Minibus_Taxi[which(Minibus_Taxi$Peak=="Off-peak"),]
Minibus_Taxi_Offpeak <- Minibus_Taxi_Offpeak[-c(6,11)]

# Data for heatmap 

x <- seq(1,10000,10)
y <- c(0.01,seq(0.1,150,0.1)) 
gg <- expand.grid(Q=x,P=y)
gg$a <- with(gg,xya.func(Q,P))      # need long format for ggplot
max <- max(Results$risk,Results_transport$risk)
max_high <- max(Results$risk_high,Results_transport$risk_high)
min <- min(Results$risk,Results_transport$risk)
min_low <- min(Results$risk_low,Results_transport$risk_low)
median_val<-median(c(Results$risk,Results_transport$risk))
#gg$a[gg$a>max_high]<-NA
#gg$a[gg$a<min_low]<-NA
#gg$a[gg$a<min]<-NA
#gg$z <- gg$a/max
gg$z <- gg$a/median_val
#gg$logz <- log(gg$z)
gg$logz <- gg$z
max(gg$logz,na.rm=TRUE)
min(gg$logz,na.rm=TRUE)
gg$P[gg$P==0.01]<-0

Results$RR<-Results$risk/median_val
Results$RR_low<-Results$risk_low/median_val
Results$RR_high<-Results$risk_high/median_val
Results_transport$RR<-Results_transport$risk/median_val
Results_transport$RR_low<-Results_transport$risk_low/median_val
Results_transport$RR_high<-Results_transport$risk_high/median_val

brks <- cut(gg$logz,breaks=c(0,0.1,0.5,1,2,10,10000), ordered_result = T)
levels(brks) <- gsub(","," - ", levels(brks), fixed=TRUE)
levels(brks) <- gsub("\\(|\\]","", levels(brks))
gg$brks <- brks  # reformat guide labels

gg$brks2<-1
gg$brks2[gg$logz>0.1]<-2
gg$brks2[gg$logz>0.5]<-3
gg$brks2[gg$logz>1]<-4
gg$brks2[gg$logz>2]<-5
gg$brks2[gg$logz>10]<-6
gg$brks2<-as.factor(gg$brks2)


#Polygons
ids <- factor(c("1", "2", "3", "4", "5", "6"))
values <- data.frame(
  id = ids,
  value = factor(c("6", "5", "4", "3", "2", "1"))
)

positions <- data.frame(
  id = rep(ids, each = 3),
  x = c(0,150,150,
        0,150,150,
        0,150,150,
        0,150,150,
        0,150,150,
        0,150,0),
  y = c(0,0,(150/median_val/10),
        0,(150/median_val/10),(150/median_val/2),
        0,(150/median_val/2),(150/median_val/1),
        0,(150/median_val/1),(150/median_val/0.5),
        0,(150/median_val/0.5),(150/median_val/0.1),
        0,(150/median_val/0.1),6000)
)
datapoly <- merge(values, positions, by = c("id"))



#### Plots ####
Church.plot <- ggplot() +
  #geom_raster(gg,  mapping = aes(x = P, y = Q, fill=brks)) +
  geom_polygon(datapoly,mapping=aes(x=x,y=y,fill=value,group=id))+
  scale_fill_manual(values=alpha(c("#4472C4","#6D91D1","#9FB7E1","#FF9393","#FF0D0D","#9E0000"),1))+
  theme_bw() +
  coord_cartesian(xlim = c(0,26),ylim = c(0,6050), expand = FALSE) +
  geom_point(Church, mapping = aes(x=Other_pop, y= Q), color='black', size=1) +
  ggtitle ("a) Church**") + theme(plot.title = element_text(size = 12)) +
  theme(axis.text=element_text(size=8), axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90)) +
  theme(axis.title.x = element_blank()) +
  ylab("Ventilation rate (l/s)") +
  theme(legend.position = "none")+
  geom_errorbar(data = Church, mapping = aes(x= Other_pop, ymin=CI1, ymax=CI2), width = 1)

Salon.plot <- ggplot() +
  #geom_raster(gg,  mapping = aes(x = P, y = Q, fill=brks)) +
  geom_polygon(datapoly,mapping=aes(x=x,y=y,fill=value,group=id))+
  scale_fill_manual(values=alpha(c("#4472C4","#6D91D1","#9FB7E1","#FF9393","#FF0D0D","#9E0000"),1))+
  theme_bw() +
  coord_cartesian(xlim = c(0,26),ylim = c(0,700), expand = FALSE) +
  geom_point(Salon, mapping = aes(x=Other_pop, y= Q), color='black', size=1) +
  ggtitle ("b) Salon") + theme(plot.title = element_text(size = 12)) +
  theme(axis.text=element_text(size=8), axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  theme(axis.title.x = element_blank()) +
  theme(axis.title.y = element_blank()) +
  theme(legend.position = "none")+
  geom_errorbar(data = Salon, mapping = aes(x= Other_pop, ymin=CI1, ymax=CI2), width = 1)

Shebeen.plot <- ggplot() +
  #geom_raster(gg,  mapping = aes(x = P, y = Q, fill=brks)) +
  geom_polygon(datapoly,mapping=aes(x=x,y=y,fill=value,group=id))+
  scale_fill_manual(name="Relative rate of infection*",
                    values=alpha(c("#4472C4","#6D91D1","#9FB7E1","#FF9393","#FF0D0D","#9E0000"),1))+
  theme_bw() +
  ggtitle ("c) Bar") + theme(plot.title = element_text(size = 12)) +
  coord_cartesian(xlim = c(0,26),ylim = c(0,700), expand = FALSE) +
  geom_point(Shebeen, mapping = aes(x=Other_pop, y= Q), color='black', size=1) +
  guides(color = guide_legend(override.aes = list(size = 0.4))) +
  theme(axis.text=element_text(size=8), axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  theme(axis.title.x = element_blank()) +
  theme(axis.title.y = element_blank()) +
  theme(legend.position = "none") +
  geom_errorbar(data = Shebeen, mapping = aes(x= Other_pop, ymin=CI1, ymax=CI2), width = 1)

Shop.plot <- ggplot() +
  #geom_raster(gg,  mapping = aes(x = P, y = Q, fill=brks)) +
  geom_polygon(datapoly,mapping=aes(x=x,y=y,fill=value,group=id))+
  scale_fill_manual(values=alpha(c("#4472C4","#6D91D1","#9FB7E1","#FF9393","#FF0D0D","#9E0000"),1))+
  theme_bw() +
  ggtitle ("d) Shop") + theme(plot.title = element_text(size = 12)) +
  coord_cartesian(xlim = c(0,26),ylim = c(0,700), expand = FALSE) +
  geom_point(Shop, mapping = aes(x=Other_pop, y= Q), color='black', size=1) +
  theme(axis.text=element_text(size=8), axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  theme(axis.title.x = element_blank()) +
  ylab("Ventilation rate (l/s)") +
  theme(legend.position = "none")+
  geom_errorbar(data = Shop, mapping = aes(x= Other_pop, ymin=CI1, ymax=CI2), width = 1)

Clinic.plot <- ggplot() +
  #geom_raster(gg,  mapping = aes(x = P, y = Q, fill=brks)) +
  geom_polygon(datapoly,mapping=aes(x=x,y=y,fill=value,group=id))+
  scale_fill_manual(values=alpha(c("#4472C4","#6D91D1","#9FB7E1","#FF9393","#FF0D0D","#9E0000"),1))+
  theme_bw() +
  ggtitle ("e) Clinic**") + theme(plot.title = element_text(size = 12)) +
  coord_cartesian(xlim = c(0,80),ylim = c(0,1500), expand = FALSE) +
  geom_point(Clinic, mapping = aes(x=Other_pop, y= Q), color='black', size=1) +
  theme(axis.text=element_text(size=8), axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  theme(axis.title.x = element_blank()) +
  theme(axis.title.y = element_blank()) +
  theme(legend.position = "none")+
  geom_errorbar(data = Clinic, mapping = aes(x= Other_pop, ymin=CI1, ymax=CI2), width = 1)

Bus.plot <- ggplot() +
  #geom_raster(gg,  mapping = aes(x = P, y = Q, fill=brks)) +
  geom_polygon(datapoly,mapping=aes(x=x,y=y,fill=value,group=id))+
  theme_bw() +
  scale_fill_manual(values=alpha(c("#4472C4","#6D91D1","#9FB7E1","#FF9393","#FF0D0D","#9E0000"),1),
                    labels=c("0 - 0.1","0.1 - 0.5","0.5 - 1","1 - 2","2 - 10",">10"),
                    name="Relative rate of infection*")+
  coord_cartesian(xlim = c(0,26),ylim = c(0,700), expand = FALSE) +
  geom_point(Bus, mapping = aes(x=Other_pop, y= Q), color='black', size=1) +
  #scale_color_manual(values=c("Peak" = "#990000", "Off-peak"='Black'), drop = FALSE) +
  #guides(color=FALSE) + 
  ggtitle ("f) Bus") + theme(plot.title = element_text(size = 12)) +
  theme(axis.text=element_text(size=8), axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  theme(axis.title.x = element_blank()) +
  theme(axis.title.y = element_blank()) +
  theme(legend.title = element_text(size = 10), 
        legend.text = element_text(size = 8)) +
  geom_errorbar(data = Bus, mapping = aes(x= Other_pop, ymin=CI1, ymax=CI2), width = 1)

Minibus_taxi_peak.plot <- ggplot() +
  #geom_raster(gg,  mapping = aes(x = P, y = Q, fill=brks)) +
  geom_polygon(datapoly,mapping=aes(x=x,y=y,fill=value,group=id))+
  theme_bw() +
  scale_fill_manual(values=alpha(c("#4472C4","#6D91D1","#9FB7E1","#FF9393","#FF0D0D","#9E0000"),1))+
  coord_cartesian(xlim = c(0,26),ylim = c(0,700), expand = FALSE) +
  geom_point(Minibus_Taxi_Peak, mapping = aes(x=Other_pop, y= Q) , color='black', size=1) +
  ggtitle ("g) Minibus taxi - Peak") + theme(plot.title = element_text(size = 12)) +
  theme(axis.text=element_text(size=8), axis.title=element_text(size=10)) +
  #scale_color_manual(values=c("Peak" = "#990000", "Off-peak"='Black')) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  xlab("Mean other people present") +
  ylab("Ventilation rate (l/s)") +
  theme(legend.position = "none") +
  geom_errorbar(data = Minibus_Taxi_Peak, mapping = aes(x= Other_pop, ymin=CI1, ymax=CI2), width = 1)

Minibus_Taxi_Offpeak.plot <- ggplot() +
  #geom_raster(gg,  mapping = aes(x = P, y = Q, fill=brks), interpolate = TRUE) +
  geom_polygon(datapoly,mapping=aes(x=x,y=y,fill=value,group=id))+
  theme_bw() +
  scale_fill_manual(values=alpha(c("#4472C4","#6D91D1","#9FB7E1","#FF9393","#FF0D0D","#9E0000"),1))+
  coord_cartesian(xlim = c(0,26),ylim = c(0,700), expand = FALSE) +
  geom_point(Minibus_Taxi_Offpeak, mapping = aes(x=Other_pop, y= Q), color='black', size=1) +
  ggtitle ("h) Minibus taxi - Off-peak") + theme(plot.title = element_text(size = 12)) +
  theme(axis.text=element_text(size=8), axis.title=element_text(size=10)) +
  #scale_color_manual(values=c("Peak" = "#990000", "Off-peak"='Black')) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  xlab("Mean other people present") +
  theme(axis.title.y = element_blank()) +
  ylab("Q(l/s)")+
  theme(legend.position = "none") +
  geom_errorbar(data = Minibus_Taxi_Offpeak, mapping = aes(x= Other_pop, ymin=CI1, ymax=CI2), width = 1)

Train.plot <- ggplot() +
  #geom_raster(gg,  mapping = aes(x = P, y = Q, fill=brks)) +
  geom_polygon(datapoly,mapping=aes(x=x,y=y,fill=value,group=id))+
  scale_fill_manual(values=alpha(c("#4472C4","#6D91D1","#9FB7E1","#FF9393","#FF0D0D","#9E0000"),1))+
  theme_bw() +
  coord_cartesian(xlim = c(0,150),ylim = c(0,3000), expand = FALSE) +
  geom_point(Train, mapping = aes(x=Other_pop, y= Q), color='black', size=1) +
  #scale_color_manual(values=c("Peak" = "#990000", "Off-peak"='Black'), drop = FALSE, name="Transport hours") +
  ggtitle ("i) Train**") + theme(plot.title = element_text(size = 12)) +
  theme(axis.text=element_text(size=8), axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  xlab("Mean other people present") +
  #theme(legend.title = element_text(size = 10), 
  #      legend.text = element_text(size = 8)) +
  theme(axis.title.y = element_blank()) +
  guides(fill=FALSE, colour = guide_legend(override.aes = list(size=1)))+
  geom_errorbar(data = Train, mapping = aes(x= Other_pop, ymin=CI1, ymax=CI2), width = 3)

setwd("C:/Users/Nicky/Dropbox/R Analysis Ventilation/Final plots")
pdf(paste0("Main figure.pdf"), paper="a4r", width=12,height=8,onefile=FALSE)
(Church.plot + Salon.plot + Shebeen.plot) / (Shop.plot + Clinic.plot + Bus.plot) / (Minibus_taxi_peak.plot + Minibus_Taxi_Offpeak.plot + Train.plot)
dev.off()
#####

write.csv(Results,file="RR_estimates_buildings.csv")
write.csv(Results_transport,file="RR_estimates_transport.csv")





  





  